function range_percentile();

% Function for calculating summed percentiles from a number of min-max ranges, assuming uniform
% probability distribution between the individual min-max values and equal weight of each individual
% min-max range. Input in columns with each odd number column containing range min values and the
% following even number column containing range max values. Output saved in file out.txt with row 1
% giving the IQR for input columns 1-2, row 2 giving the IQR for input columns 3-4 and so on.
% This is free software: you can use/copy/modify/distribute as long as you keep it free/open.
% Jakob Heyman 2019 (jakob.heyman@gu.se)

clear all;
load input.txt;

num = size(input,2)/2;
percentv = [0.25 0.5 0.75];

for i = 1:num;
    minv = input(:,i*2-1);
    maxv = input(:,i*2);
    
    % remove -1 values (used for nohit)
    minv(minv==-1) = [];
    maxv(maxv==-1) = [];
    
    dv = (min(minv):0.01:max(maxv));
    
    for j = 1:numel(minv)
        summ(j,:) = (dv >= minv(j)) .* (dv <= maxv(j)) ./ (maxv(j)-minv(j));
    end;
    
    sumv = sum(summ);
    cumsumv = cumsum(sumv);
    cumsumv = cumsumv./cumsumv(end);
    for j = 1:numel(percentv);
        outv(i,j) = interp1(cumsumv,dv,percentv(j));
    end;
    clear summ;
end;

out = fopen('out.txt','w');
for i = 1:size(outv,1);
    for j = 1:numel(percentv);
        fprintf(out,'%.2f',outv(i,j));
        if j<numel(percentv);
            fprintf(out,'\t');
        end;
    end
    fprintf(out,'\n');
    %fprintf(out,'%.2f\t%.2f\n',outv(i,1),outv(i,2));
end;
fclose(out);
