function out = antatm(z);

% Syntax: pressure = antatm(elevation)
%
% Units: elevation in m; pressure in hPa. Accepts vector inputs.
%
% This function converts elevation to atmospheric pressure according 
% to a best-fit relationship for Antarctic stations from:
%
% Radok, Allison, Wendler, 1996. Atmospheric pressure over the interior
% of Antarctica. Antarctic Science 0 p. 209. 
% 
% 
% Written by Greg Balco -- UW Cosmogenic Nuclide Lab
% balcs@u.washington.edu
% First version, March, 2001
% Checked October, 2005
% Part of the CRONUS-Earth online calculators: 
%      http://hess.ess.washington.edu/math
%
% Copyright 2001-2007, University of Washington
% All rights reserved
% Developed in part with funding from the National Science Foundation.
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License, version 2,
% as published by the Free Software Foundation (www.fsf.org).

% do it 

out_1 = 989.1 .* exp( z./(-7588));

% make it a row vector

if size(out_1,1) > size(out_1,2);
    out = out_1';
else;
    out = out_1;
end;
